export const ALPHABET = ['#', ...'ABCDEFGHIJKLMNOPQRSTUVWXYZ'];
export const strengthLevels = { '0.170000': 'Low', '0.370000': 'Normal', '0.670000': 'High' };
export const strengthValues = { 'Low': '0.170000', 'Normal': '0.370000', 'High': '0.670000' };
export const aspectLevels = { '0': '4:3', '1': '16:9', '21': 'Pixel Perfect' };
export const aspectValues = { '4:3': '0', '16:9': '1', 'Pixel Perfect': '21' };
export const relayOptions = [
    { labelKey: "relay_disabled", server: "", enabled: "false" },
    { labelKey: "relay_na", server: "nyc", enabled: "true" },
    { labelKey: "relay_weu", server: "madrid", enabled: "true" },
    { labelKey: "relay_sa", server: "saopaulo", enabled: "true" },
    { labelKey: "relay_sea", server: "singapore", enabled: "true" },
    { labelKey: "relay_ea", server: "chuncheon", enabled: "true" },
];
export const RETROARCH_LANG_MAP = { 'en': '0', 'es': '3', 'fr': '2', 'pt': '7', 'de': '4', 'it': '5' };
export const availableRegions = ['USA', 'Europe'];
export const availableLanguages = [{ code: 'en', name: 'English' }, { code: 'es', name: 'Español' }, { code: 'fr', name: 'Français' }, { code: 'pt', name: 'Português' }, { code: 'de', name: 'Deutsch' }, { code: 'it', name: 'Italiano' }];
export const REPEAT_DELAY = 50;
export const INITIAL_REPEAT_DELAY = 300;
export const ATTRACT_MODE_TIMEOUT = 60000; // 2 minutes
export const ATTRACT_MODE_SCROLL_INTERVAL = 5000; // 10 seconds

export const DEFAULT_APP_SETTINGS = {
    bgmVolumeLevel: 8,
    bgmPath: "default",
    language: "en",
    region: "USA",
    attractModeEnabled: "true",
    startFullscreen: false,
};

export const DEFAULT_RETROARCH_SETTINGS = {
    savestate_auto_index: "true",
    savestate_auto_load: "true",
    savestate_max_keep: "4",
    aspect_ratio_index: "0",
    video_fullscreen: "true",
    video_windowed_fullscreen: "true",
    input_overlay_enable: "true",
    input_overlay_opacity: "0.370000",
    rewind_enable: "false",
    input_hold_fast_forward_axis: "nul",
    cheevos_enable: "false",
    cheevos_username: "",
    cheevos_password: "",
    user_language: "0"
};

export const IN_GAME_DEFAULTS = {
    savestate_auto_index: DEFAULT_RETROARCH_SETTINGS.savestate_auto_index,
    savestate_auto_load: DEFAULT_RETROARCH_SETTINGS.savestate_auto_load,
    savestate_max_keep: DEFAULT_RETROARCH_SETTINGS.savestate_max_keep,
    aspect_ratio_index: DEFAULT_RETROARCH_SETTINGS.aspect_ratio_index,
    video_fullscreen: DEFAULT_RETROARCH_SETTINGS.video_fullscreen,
    input_overlay_enable: DEFAULT_RETROARCH_SETTINGS.input_overlay_enable,
    input_overlay_opacity: DEFAULT_RETROARCH_SETTINGS.input_overlay_opacity,
    rewind_enable: DEFAULT_RETROARCH_SETTINGS.rewind_enable,
    input_hold_fast_forward_axis: DEFAULT_RETROARCH_SETTINGS.input_hold_fast_forward_axis,
};

export let games = [];
export let selectedIndex = 0;
export let APP_PATHS = {};
export let UI_URLS = {};
export let saveStateCache = {};
export let isMenuOpen = false;
export let menuSelectionIndex = 0;
export let twoPlayerGames = [];
export let isAlphaBarOpen = false;
export let alphaSelectionIndex = 0;
export let isSaveStateMenuOpen = false;
export let saveStateSelectionIndex = 0;
export let currentSaveStates = [];
export let isSaveStateModalOpen = false;
export let saveStateModalSelectionIndex = 0;
export let isTopMenuFocused = false;
export let topMenuSelectionIndex = 0;
export let isLobbyOpen = false;
export let lobbyGames = [];
export let lobbySelectionIndex = 0;
export let isPowerMenuOpen = false;
export let powerMenuSelectionIndex = 0;
export let isAudioMenuOpen = false;
export let audioMenuSelectionIndex = 0;
export let isDisplayMenuOpen = false;
export let displayMenuSelectionIndex = 0;
export let isNetworkMenuOpen = false;
export let networkMenuSelectionIndex = 0;
export let isUsernameModalOpen = false;
export let usernameModalSelectionIndex = 0;
export let isConfigMenuOpen = false;
export let configMenuSelectionIndex = 0;
export let isRaLoginModalOpen = false;
export let raLoginModalSelectionIndex = 0;
export let isProcessActive = false;
export let hasUserInteracted = false;
export let notificationData = null;
export let notificationTimeout = null;
export let appSettings = {};
export let availableBgmTracks = [];
export let currentTranslations = {};
export let previousButtonStates = {};
export let buttonPressedTime = {};
export let lastDirectionalInputTime = {};
export let currentRelayIndex = 0;
export let initialRelayIndex = 0;
export let inactivityTimer = null;
export let attractModeInterval = null;
export let attractPlaylist = [];
export let attractPlaylistIndex = 0;

export function setInitialData(data) {
    games = data.games;
    twoPlayerGames = data.twoPlayerGames;
    availableBgmTracks = data.bgmTracks;
    APP_PATHS = data.appPaths;
    UI_URLS = data.uiUrls;
}

export function setInitialSettings(settings) {
    appSettings = { ...DEFAULT_APP_SETTINGS, ...DEFAULT_RETROARCH_SETTINGS, ...settings };
}

export function setSelectedIndex(value) { selectedIndex = value; }
export function setMenuOpen(value) { isMenuOpen = value; }
export function setMenuSelectionIndex(value) { menuSelectionIndex = value; }
export function setAlphaBarOpen(value) { isAlphaBarOpen = value; }
export function setAlphaSelectionIndex(value) { alphaSelectionIndex = value; }
export function setSaveStateMenuOpen(value) { isSaveStateMenuOpen = value; }
export function setSaveStateSelectionIndex(value) { saveStateSelectionIndex = value; }
export function setCurrentSaveStates(value) { currentSaveStates = value; }
export function setSaveStateModalOpen(value) { isSaveStateModalOpen = value; }
export function setSaveStateModalSelectionIndex(value) { saveStateModalSelectionIndex = value; }
export function setTopMenuFocused(value) { isTopMenuFocused = value; }
export function setTopMenuSelectionIndex(value) { topMenuSelectionIndex = value; }
export function setLobbyOpen(value) { isLobbyOpen = value; }
export function setLobbyGames(value) { lobbyGames = value; }
export function setLobbySelectionIndex(value) { lobbySelectionIndex = value; }
export function setPowerMenuOpen(value) { isPowerMenuOpen = value; }
export function setPowerMenuSelectionIndex(value) { powerMenuSelectionIndex = value; }
export function setAudioMenuOpen(value) { isAudioMenuOpen = value; }
export function setAudioMenuSelectionIndex(value) { audioMenuSelectionIndex = value; }
export function setDisplayMenuOpen(value) { isDisplayMenuOpen = value; }
export function setDisplayMenuSelectionIndex(value) { displayMenuSelectionIndex = value; }
export function setNetworkMenuOpen(value) { isNetworkMenuOpen = value; }
export function setNetworkMenuSelectionIndex(value) { networkMenuSelectionIndex = value; }
export function setUsernameModalOpen(value) { isUsernameModalOpen = value; }
export function setUsernameModalSelectionIndex(value) { usernameModalSelectionIndex = value; }
export function setConfigMenuOpen(value) { isConfigMenuOpen = value; }
export function setConfigMenuSelectionIndex(value) { configMenuSelectionIndex = value; }
export function setRaLoginModalOpen(value) { isRaLoginModalOpen = value; }
export function setRaLoginModalSelectionIndex(value) { raLoginModalSelectionIndex = value; }
export function setProcessActive(value) { isProcessActive = value; }
export function setHasUserInteracted(value) { hasUserInteracted = value; }
export function setNotificationData(value) { notificationData = value; }
export function setNotificationTimeout(value) { notificationTimeout = value; }
export function setCurrentTranslations(value) { currentTranslations = value; }
export function setCurrentRelayIndex(value) { currentRelayIndex = value; }
export function setInitialRelayIndex(value) { initialRelayIndex = value; }
export function setInactivityTimer(value) { inactivityTimer = value; }
export function setAttractModeInterval(value) { attractModeInterval = value; }
export function setAttractPlaylist(value) { attractPlaylist = value; }
export function setAttractPlaylistIndex(value) { attractPlaylistIndex = value; }